# Sprite animation (PNG / native SDL 3.3 / C)

**Demo in the browser:** https://8observer8.github.io/examples/sdl3/sprite-animation-native-png-sdl-3.3.4-c

**EXE for Windows 10, 64-bit:** [sprite-animation-native-png-sdl-3.3.4-c-exe.zip](https://www.dropbox.com/scl/fi/ew8oxabb8ychuuqqn3hwy/sprite-animation-native-png-sdl-3.3.4-c-exe.zip?rlkey=7h63ms5kd6rg01f1i10anx3a8&st=rpyccvdl&raw=1)
- Zip size: 1.12 MB
- Unzipped: 2.73 MB

---

## File Sizes

**WASM (built with Emscripten 4.0.15):**

- `index.html` — 971 bytes
- `app.js` — 183 KB
- `app.wasm` — 809 MB
- **Total:** 994 KB

**EXE (built with MinGW GCC 11.2):**

- EXE — 81.1 KB
- `SDL3.dll` (v3.3.4) — 2.65 MB
- Assets ([idle.png](https://pixelfrog-assets.itch.io/tiny-swords)) — 8.3 KB
- **Total:** 2.73 MB

---

## Tools to Build the EXE

- [MinGW GCC 11.2](https://github.com/brechtsanders/winlibs_mingw/releases/download/11.2.0-14.0.0-9.0.0-ucrt-r7/winlibs-x86_64-posix-seh-gcc-11.2.0-mingw-w64ucrt-9.0.0-r7.zip) (zip - 178 MB, unzipped - 671 MB)
- [SDL3-3.3.4-win32-x64.zip](https://www.dropbox.com/scl/fi/6zojft1cdj2kzpljj2j5c/SDL3-3.3.4-win32-x64.zip?rlkey=lxvf4lzsfiv846ajpnic49s5j&st=m0alnzdr&raw=1) (zip - 1.09 MB, unzipped - 2.65 MB)
- [SDL3-devel-3.3.4-mingw.zip](https://www.dropbox.com/scl/fi/njib4pzrkuplxkomqihhg/SDL3-devel-3.3.4-mingw.zip?rlkey=69bhrsjx2w4j4ca1rc5arfbq5&st=uiymyff4&raw=1) (zip - 2.63 MB, unzipped - 9.42 MB)

---

## Tools to Build WebAssembly

- [Emscripten 4.0.15](https://emscripten.org/docs/getting_started/downloads.html) (1.82 GB)
- [SDL3-devel-3.3.4-wasm.zip](https://www.dropbox.com/scl/fi/ogokwxxc64f0lgf01q9oe/SDL3-devel-3.3.4-wasm.zip?rlkey=p2ggy9ynptdlbroi9ixaj1d2c&st=wtd9g7zx&raw=1) (zip - 1.21 MB, unzipped - 5.2 MB)

---

## How to Build EXE (Windows)

- Add [MinGW GCC 11.2](https://github.com/brechtsanders/winlibs_mingw/releases/download/11.2.0-14.0.0-9.0.0-ucrt-r7/winlibs-x86_64-posix-seh-gcc-11.2.0-mingw-w64ucrt-9.0.0-r7.zip) `bin` folder to your `PATH`.
- Add [SDL3-3.3.4-win32-x64.zip](https://www.dropbox.com/scl/fi/6zojft1cdj2kzpljj2j5c/SDL3-3.3.4-win32-x64.zip?rlkey=lxvf4lzsfiv846ajpnic49s5j&st=m0alnzdr&raw=1) folder to your `PATH`.
- Configure paths in `config-web.bat` for your SDL3 libraries.
- From the project root, run:

```bat
config-exe
build-exe
run-exe
```

## How to Build WebAssembly

1. Set up [Emscripten 4.0.15](https://emscripten.org/docs/getting_started/downloads.html) and Node.js
2. Install http-server globally:

```bat
npm i http-server -g
```

3. Configure paths in `config-web.bat` for your SDL3 libraries.
4. From the project root, run:

```bat
config-web
build-web
http-server -c-1
```

5. Open your browser and go to http://localhost:8080 to run the app locally.

> Note: You can also run the WASM app on Android via Wi-Fi using http-server. After starting the server, it will show local URL addresses — just type one into your mobile browser.

This example uses a sprite sheet from the following the asset pack: https://pixelfrog-assets.itch.io/tiny-swords
