import ctypes
import os

os.environ["SDL_MAIN_USE_CALLBACKS"] = "1"
os.environ["SDL_RENDER_DRIVER"] = "opengl"

import sdl3

renderer = ctypes.POINTER(sdl3.SDL_Renderer)()
window = ctypes.POINTER(sdl3.SDL_Window)()
wave = ctypes.POINTER(sdl3.Mix_Chunk)()

@sdl3.SDL_AppInit_func
def SDL_AppInit(appstate, argc, argv):
    global wave

    if not sdl3.SDL_Init(sdl3.SDL_INIT_VIDEO | sdl3.SDL_INIT_AUDIO):
        sdl3.SDL_Log("Couldn't initialize SDL: %s".encode() % sdl3.SDL_GetError())
        return sdl3.SDL_APP_FAILURE

    if not sdl3.SDL_CreateWindowAndRenderer("Play a sound by click using PySDL3".encode(), 380, 380, 0, window, renderer):
        sdl3.SDL_Log("Couldn't create window/renderer: %s".encode() % sdl3.SDL_GetError())
        return sdl3.SDL_APP_FAILURE

    sdl3.SDL_SetRenderVSync(renderer, 1) # Turn on vertical sync

    spec = sdl3.SDL_AudioSpec()
    spec.freq = sdl3.MIX_DEFAULT_FREQUENCY
    spec.format = sdl3.MIX_DEFAULT_FORMAT
    spec.channels = sdl3.MIX_DEFAULT_CHANNELS

    # Open the audio device
    if not sdl3.Mix_OpenAudio(0, spec):
        sdl3.SDL_Log("Couldn't open an audio device: %s".encode() % SDL_GetError())
        return sdl3.SDL_APP_FAILURE

    # Load the WAV file
    soundFilePath = "./assets/audio/picked-coin-echo-2.wav".encode();
    wave = sdl3.Mix_LoadWAV(soundFilePath);
    if not wave:
        sdl3.SDL_Log("Couldn't open the file: %s".encode() % soundFilePath)
        sdl3.SDL_Log("Error: %s".encode() % sdl3.SDL_GetError())
        return sdl3.SDL_APP_FAILURE;

    return sdl3.SDL_APP_CONTINUE

@sdl3.SDL_AppEvent_func
def SDL_AppEvent(appstate, event):
    if sdl3.SDL_DEREFERENCE(event).type == sdl3.SDL_EVENT_QUIT:
        return sdl3.SDL_APP_SUCCESS
    elif sdl3.SDL_DEREFERENCE(event).type == sdl3.SDL_EVENT_MOUSE_BUTTON_DOWN:
        # Play the sound effect
        sdl3.Mix_PlayChannel(-1, wave, 0);

    return sdl3.SDL_APP_CONTINUE

@sdl3.SDL_AppIterate_func
def SDL_AppIterate(appstate):
    sdl3.SDL_SetRenderDrawColor(renderer, 210, 220, 210, sdl3.SDL_ALPHA_OPAQUE)
    sdl3.SDL_RenderClear(renderer)
    sdl3.SDL_RenderPresent(renderer)
    return sdl3.SDL_APP_CONTINUE

@sdl3.SDL_AppQuit_func
def SDL_AppQuit(appstate, result):
    global wave
    # SDL will clean up the window/renderer for us
    if wave:
        sdl3.Mix_FreeChunk(wave)
        wave = None
